<?php

namespace Modules\Common\Entities\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Entity extends Model 
{

    protected $table = 'entities';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function type()
    {
        return $this->belongsTo('EntityType', 'type_id', 'id');
    }

    public function addresses()
    {
        return $this->hasMany('EntityAddress', 'entity_id', 'id');
    }

    public function legal_representatives()
    {
        return $this->hasMany('EntityLegalRepresentative', 'entity_id', 'id');
    }

    public function nationality()
    {
        return $this->belongsTo('Country', 'country_id', 'id');
    }

    public function categoryTypes()
    {
        return $this->belongsToMany('CategoryType', 'entity_category_type');
    }

}